let averagingAmt = 0.01;
let circles = [];
let maxCircles = 200;
let frameInterval = 300;
let currentStep = 0;
let mic;
let breathingRadiusOffset = 0;
let micStarted = false;
let startButton;

// 音檔變數（請將音檔放在 assets 資料夾中，並確認檔名）
let papaSound, cookingSound, babyLaughSound, loveUSound, childSound;

function preload() {
  // 載入音檔
  papaSound = loadSound('assets/Papa.mp3');
  cookingSound = loadSound('assets/Cooking 2.mp3');
  babyLaughSound = loadSound('assets/Baby laugh.mp3');
  loveUSound = loadSound('assets/love u.mp3');
  childSound = loadSound('assets/Child.mp3');
}

function setup() {
  // 建立畫布並指定父層（例如：header）
  createCanvas(600, 600).parent('header');

  // 建立「啟動」按鈕，因為瀏覽器需要使用者互動後才能啟用音訊
  startButton = createButton('Click to allow microphone access and start the sound visualization');
  startButton.position((windowWidth / 2) - 200, windowHeight / 3, 'relative');
  startButton.size(400, 60);
  startButton.style('font-size', '20px')
             .style('color', '#988a6b')
             .style('background-color', '#f1f1f1')
             .style('text-align', 'center')
             .style('border', '2px #8e653c')
             .style('transition-duration', '0.4s');

  startButton.mouseOver(() => {
    startButton.style('background-color', "#ffffff");
    startButton.style('border', '4px #988a6b');
  });

  startButton.mouseOut(() => {
    startButton.style('background-color', "#f1f1f1");
    startButton.style('border', '2px #8e653c');
  });

  // 使用者點擊按鈕後，啟動 AudioContext 與麥克風
  startButton.mousePressed(() => {
    getAudioContext().resume().then(() => {
      mic = new p5.AudioIn();
      mic.start();
      micStarted = true;
      startButton.hide();
    });
  });
}

function draw() {
  if (!micStarted) return; // 等待使用者點擊啟動

  // 背景使用半透明黑色，形成軌跡效果
  background(0, 10);

  // 將畫布中心作為原點，並調整起始角度（12 點鐘方向）
  translate(width / 2, height / 2);
  rotate(-PI / 2);
  translate(-width / 2, -height / 2);

  // 每隔一定幀數生成一個小粒子（圓形）
  if (frameCount % frameInterval == 0 && circles.length < maxCircles) {
    let angle = radians(currentStep * 360);
    let radius = 0;
    let x = width / 2 + cos(-angle) * radius;
    let y = height / 2 + sin(-angle) * radius;
    circles.push(new Circle(x, y));
    currentStep = (currentStep + 1) % 200;
  }

  // 更新並繪製所有粒子，超過透明度範圍者刪除
  for (let i = circles.length - 1; i >= 0; i--) {
    let circle = circles[i];
    circle.update();
    circle.display();

    if (circle.opacity <= 0) {
      circles.splice(i, 1);
    }
  }

  // 根據麥克風輸入取得聲音幅度，用於影響視覺效果
  let amplitude = mic.getLevel() * 1000;

  // 呼吸效果：根據正弦函數調整形狀半徑
  breathingRadiusOffset = map(sin(frameCount * 0.015), -1, 1, -180, 30);

  // 呼叫 NoisyShape 類別，繪製帶有噪波效果的圓形輪廓
  NoisyShape.draw(
    width / 2,
    height / 2,
    360,
    200 + breathingRadiusOffset,
    amplitude
  );
}

// 透過 keyPressed() 處理 Makey Makey 輸入（Makey Makey 模擬鍵盤事件）
// 可根據鍵盤按鍵播放不同音檔
function keyPressed() {
  console.log("keyPressed: ", key, keyCode);
  if (!micStarted) return;  // 確保使用者已啟動音訊

  if (keyCode === UP_ARROW) {
    if (!papaSound.isPlaying()) {
      papaSound.play();
    }
  } else if (keyCode === DOWN_ARROW) {   
    if (!cookingSound.isPlaying()) {
      cookingSound.play();
    }
  } else if (keyCode === LEFT_ARROW) {
    if (!babyLaughSound.isPlaying()) {
      babyLaughSound.play();
    }
  } else if (keyCode === RIGHT_ARROW) {
    if (!loveUSound.isPlaying()) {
      loveUSound.play();
    }
  } else if (key === ' ') {
    if (!childSound.isPlaying()) {
      childSound.play();
    }
  }
}

// ------------------ Class Definitions ------------------

class Circle {
  constructor(x, y) {
    this.x = x;
    this.y = y;
    this.r = random(10, 30); // 粒子大小隨機
    this.maxOpacity = 255;   // 最大透明度
    this.opacity = 0;        // 初始透明度
    this.fadeSpeed = random(2, 5); // 淡入淡出速度
  }
  
  update() {
    // 根據淡入淡出速度更新透明度
    this.opacity += this.fadeSpeed;
    if (this.opacity > this.maxOpacity || this.opacity < 0) {
      this.fadeSpeed *= -1; // 達到極限後反轉
    }
  }
  
  display() {
    noStroke();
    // 設定發光效果
    drawingContext.shadowBlur = 10;
    drawingContext.shadowColor = color(255, 0, 0, this.opacity);
    fill(255, this.opacity);
    ellipse(this.x, this.y, this.r, this.r);
  }
}

class NoisyShape {
  static draw(ox, oy, vertNum, radius, noiseAmplitude) {
    let angleStep = TWO_PI / vertNum;
    let noiseOffset = frameCount * 0.08;  // 控制噪波隨時間變化
  
    push();
    translate(ox, oy);
  
    noFill();
    stroke(255, 150);
    strokeWeight(1);
    beginShape();
  
    for (let vn = 0; vn <= vertNum; vn++) {
      let angle = vn * angleStep;
      let baseX = cos(angle) * radius;
      let baseY = sin(angle) * radius;
  
      // 根據噪波值產生不規則偏移
      let noiseValue = noise(vn * 0.2, noiseOffset);
      let offset = noiseValue * noiseAmplitude;
  
      let finalX = baseX + cos(angle) * offset;
      let finalY = baseY + sin(angle) * offset;
  
      curveVertex(finalX, finalY);
    }
  
    endShape(CLOSE);
    pop();
  }
}
